unit Upl_dlg3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBCtrls, Grids, DBGrids,
  StdCtrls, Buttons, ExtCtrls,
  Db, DBTables;

type
  TCategoryOtherAddDlg = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Panel5: TPanel;
    DBNavigator1: TDBNavigator;
    DBNavigator2: TDBNavigator;
    DBGrid1: TDBGrid;
    procedure TblFilesCatBeforePost(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  CategoryOtherAddDlg: TCategoryOtherAddDlg;

implementation

uses DataModule;

{$R *.DFM}

procedure TCategoryOtherAddDlg.TblFilesCatBeforePost(DataSet: TDataSet);
begin
  DM.TblFilesCat.FieldByName('FileGrpID').AsInteger:= DM.TblFilesGrp.FieldByName('FileGrpID').AsInteger;
end;

procedure TCategoryOtherAddDlg.FormCreate(Sender: TObject);
begin
  // set form caption
  Caption:= 'Add ' + DM.TblFilesGrp.FieldByName('FileGrpName').AsString + ' Category';
  // set filter to show only subset of categories
  DM.TblFilesCat.Filter:= 'FileGrpID = ' +  DM.TblFilesGrp.FieldByName('FileGrpID').AsString;
  DM.TblFilesCat.Filtered:= true;
  // set controls
  DBGrid1.DataSource:= DM.DSFilesCat;
  DBNavigator1.DataSource:= DM.DSFilesCat;
  DBNavigator2.DataSource:= DM.DSFilesCat;
  // assign event
  DM.TblFilesCat.BeforePost:= TblFilesCatBeforePost;
end;

procedure TCategoryOtherAddDlg.FormDestroy(Sender: TObject);
begin
  // remove dependencies
  DM.TblFilesCat.BeforePost:= nil;
  DM.TblFilesCat.Filtered:= false;
  DBGrid1.DataSource:= nil;
  DBNavigator1.DataSource:= nil;
  DBNavigator2.DataSource:= nil;
end;

end.
